r"""{{ language | title }}
==========================
"""

from typing import Any

from .._metainfo import SOURCE, project


def init_schema() -> dict[str, Any]:
    r"""Init schema.

    :rtype: dict[str, Any]
    """
    filetype = "{{ language }}"
    schemas = {
        filetype: {
            "$id": (
                f"{SOURCE}/blob/main/"
                f"src/termux_language_server/assets/json/{filetype}.json"
            ),
            "$schema": "http://json-schema.org/draft-07/schema#",
            "$comment": (
                "Don't edit this file directly! It is generated by "
                f"`{project} --generate-schema={filetype}`."
            ),
            "type": "object",
            "additionalProperties": False,
            "properties": {},
        }
    }
    return schemas
